﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace prj_wfrm_centreCall_tickets
{
    public partial class frmClientAfficherClientsParCentreAppel : Form
    {
        public frmClientAfficherClientsParCentreAppel()
        {
            InitializeComponent();
        }

        private void frmClientAfficherClientsParCentreAppel_Load(object sender, EventArgs e)
        {
			//Le bouton valider est par défaut indisponible tant qu'on a pas renseigné de villes
			btn_valider.Enabled = false;
			cb_villes.Items.Clear();
			DataTable resultat = new DataTable();
			//Requête qui va permettre de récupérer l'id et la ville de chaque centre
			string sql = "select CNT_NUM, CNT_VILLE from tb_centre;";
			resultat = Global.connexion(sql);

			//On ajoute dans la ComboBox tous les numéros de centre ainsi que la ville associée à chaque centre
			foreach (DataRow valeur in resultat.Rows)
			{
				cb_villes.Items.Add("Centre " + valeur["CNT_NUM"] + " - " + valeur["CNT_VILLE"]);
			}
		}

        private void btn_valider_Click(object sender, EventArgs e)
        {
			/* On récupère la valeur choisie par l'utilisateur dans la ComboBox
            Comme j'ai décidé d'afficher "Centre x - ville", ce qui nous intéresse avec le choix fait par l'utilisateur
            est le 7ème caractère de la chaine, car il correspond à l'indice du centre --> ça va nous permettre
            d'afficher uniquement les clients qui ont pour numéro de centre celui-ci */

			string choix_chaine = cb_villes.Text;
			//On récupère le numéro de centre sous forme d'entier
			int choix = int.Parse(choix_chaine[7].ToString());

			DataTable resultat = new DataTable();
			//Requête qui va permettre de récupérer l'id et la ville de chaque centre
			string sql = $"select CLN_NUM, CLN_RAISON_SOCIAL from tb_client where CLN_CNT_NUM = {choix};";
			resultat = Global.connexion(sql);

			//Avant tout on clear la ListView pour ne pas avoir de duplication
			lv_ClientsDuCentre.Items.Clear();

			//On affiche ensuite chaque ligne du résultat de la requête dans la ListView
			foreach (DataRow valeur in resultat.Rows)
			{
				ListViewItem ligne = new ListViewItem();
				ligne.Text = valeur["CLN_NUM"].ToString();
				ligne.SubItems.Add(valeur["CLN_RAISON_SOCIAL"].ToString());
				lv_ClientsDuCentre.Items.Add(ligne);
			}



		}

        private void cb_villes_SelectedIndexChanged(object sender, EventArgs e)
        {
			//Dès qu'une ville a été sélectionnée dans la ComboBox, on débloque le bouton valider
			if (cb_villes != null)
				btn_valider.Enabled = true;
			else
				btn_valider.Enabled = false;
        }
    }
}
